<?php get_header(); ?>

<section class="content">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php single_tag_title(); ?>
        </h1>

        <?php if (have_posts()) : ?>
            <div class="row">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="col-md-4">
                        <div class="item">
                            <div class="item-thumb">
                                <a href="<?php the_permalink(); ?>"
                                   title="<?php the_title(); ?>">
                                    <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                </a>
                            </div>
                            <div class="item-body">
                                <h5 class="item-tit"><?php the_title(); ?></h5>
                                <div class="item-des">
                                    <?php echo get_excerpt(15); ?>
                                </div>
                                <div class="item-url">
                                    <a class="main-hover"
                                       href="<?php the_permalink(); ?>"
                                       title="<?php the_title(); ?>">
                                        <?php _e('المزيد', 'a7md') ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php wp_pagenavi(); ?>
        <?php else : ?>
            <p>
                <?php _e('Sorry what you are looking for is not here', 'a7md') ?>
            </p>
        <?php endif; ?>

    </div>
</section>

<?php get_footer(); ?>
